package com.yd.csf.service.utils;

import org.apache.commons.lang3.reflect.FieldUtils;

import java.util.Arrays;

public class ValidateUtil {

    public static boolean isAllFieldsNull(Object obj) {
        return Arrays.stream(obj.getClass().getDeclaredFields())
                .allMatch(field -> {
                    try {
                        return FieldUtils.readField(field, obj, true) == null;
                    } catch (IllegalAccessException e) {
                        return true; // 如果无法访问，视为null
                    }
                });
    }
}
