package com.yd.csf.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.csf.api.service.ApiConditionConfigService;
import com.yd.csf.feign.client.conditionconfig.ApiConditionConfigFeignClient;
import com.yd.csf.feign.request.conditionconfig.ApiConditionConfigAddRequest;
import com.yd.csf.feign.request.conditionconfig.ApiConditionConfigEditRequest;
import com.yd.csf.feign.request.conditionconfig.ApiConditionConfigPageRequest;
import com.yd.csf.feign.response.conditionconfig.ApiConditionConfigDetailResponse;
import com.yd.csf.feign.response.conditionconfig.ApiConditionConfigPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 条件配置信息
 *
 * @author zxm
 * @since 2025-10-17
 */
@RestController
@RequestMapping("/conditionConfig")
@Validated
public class ApiConditionConfigController implements ApiConditionConfigFeignClient {

    @Autowired
    private ApiConditionConfigService apiConditionConfigService;

    /**
     * 分页查询-条件配置信息
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiConditionConfigPageResponse>> page(ApiConditionConfigPageRequest request) {
        return apiConditionConfigService.page(request);
    }

    /**
     * 详情-条件配置信息
     * @param conditionBizId
     * @return
     */
    @Override
    public Result<ApiConditionConfigDetailResponse> detail(String conditionBizId) {
        return apiConditionConfigService.detail(conditionBizId);
    }

    /**
     * 添加-条件配置信息
     * @param request
     * @return
     */
    @Override
    public Result add(ApiConditionConfigAddRequest request) {
        return apiConditionConfigService.add(request);
    }

    /**
     * 编辑-条件配置信息
     * @param request
     * @return
     */
    @Override
    public Result edit(ApiConditionConfigEditRequest request) {
        return apiConditionConfigService.edit(request);
    }

    /**
     * 删除-条件配置信息 TODO
     * @param conditionBizId
     * @return
     */
    @Override
    public Result del(String conditionBizId) {
        return apiConditionConfigService.del(conditionBizId);
    }
}
