package com.yd.csf.feign.fallback.basiclawcalculate;

import com.yd.common.result.Result;
import com.yd.csf.feign.client.basiclawcalculate.ApiBasicLawCalculateFeignClient;
import com.yd.csf.feign.request.basiclawcalculate.ApiGenerateBillingRequest;
import com.yd.csf.feign.response.basiclawcalculate.ApiGenerateBillingResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * 香港保险服务-基本法计算接口信息Feign降级处理
 */
@Slf4j
@Component
public class ApiBasicLawCalculateFeignFallbackFactory implements FallbackFactory<ApiBasicLawCalculateFeignClient> {
    @Override
    public ApiBasicLawCalculateFeignClient create(Throwable cause) {
        return new ApiBasicLawCalculateFeignClient() {
            @Override
            public Result<ApiGenerateBillingResponse> generateBilling(ApiGenerateBillingRequest request) {
                return null;
            }
        };
    }
}
