package com.yd.csf.api.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.csf.feign.request.expectedfortune.ApiExpectedFortunePageRequest;
import com.yd.csf.feign.request.expectedfortune.ApiGenerateExpectedFortuneRequest;
import com.yd.csf.feign.response.expectedfortune.ApiExpectedFortunePageResponse;
import com.yd.csf.feign.response.expectedfortune.ApiGenerateExpectedFortuneResponse;
import com.yd.csf.service.dto.QueryPolicyAndBrokerDto;
import com.yd.csf.service.model.CommissionRuleBinding;
import org.springframework.scheduling.annotation.Async;

import java.util.List;

public interface ApiExpectedFortuneService {
    Result<ApiGenerateExpectedFortuneResponse> generate(ApiGenerateExpectedFortuneRequest request);

    @Async("asyncQueryExecutor")
    Result execute(List<QueryPolicyAndBrokerDto> queryPolicyAndBrokerDtoList,
                   List<CommissionRuleBinding> commissionRuleBindingList,
                   String policyNo);

    Result<IPage<ApiExpectedFortunePageResponse>> page(ApiExpectedFortunePageRequest request);

    Result<Boolean> isGenerate(String policyNo);
}
