package com.yd.csf.feign.fallback.appointment;

import com.yd.common.result.Result;
import com.yd.csf.feign.client.appointment.ApiAppointmentFeignClient;
import com.yd.csf.feign.dto.appointment.ApiAppointmentInfoDto;
import com.yd.csf.feign.request.appointment.*;
import com.yd.csf.feign.response.appointment.ApiAppointmentAddResponse;
import com.yd.csf.feign.response.appointment.ApiAppointmentDetailResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

import javax.validation.constraints.NotBlank;

/**
 * 香港保险服务-预约信息Feign降级处理
 */
@Slf4j
@Component
public class ApiAppointmentFeignFallbackFactory implements FallbackFactory<ApiAppointmentFeignClient> {
    @Override
    public ApiAppointmentFeignClient create(Throwable cause) {
        return new ApiAppointmentFeignClient() {
            @Override
            public Result page(ApiAppointmentPageRequest request) {
                return null;
            }

            @Override
            public Result<ApiAppointmentDetailResponse> detail(String appointmentBizId) {
                return null;
            }

            @Override
            public Result<ApiAppointmentInfoDto> mainDetail(String appointmentBizId) {
                return null;
            }

            @Override
            public Result<ApiAppointmentAddResponse> add(ApiAppointmentAddRequest request) {
                return null;
            }

            @Override
            public Result addStorage(ApiAppointmentAddStorageRequest request) {
                return null;
            }

            @Override
            public Result singleEdit(ApiAppointmentInfoDto apiAppointmentInfoDto) {
                return null;
            }

            @Override
            public Result edit(ApiAppointmentEditRequest request) {
                return null;
            }

            @Override
            public Result editConfirmTime(ApiAppointmentEditConfirmTimeRequest request) {
                return null;
            }

            @Override
            public Result editFna(ApiAppointmentEditFnaRequest request) {
                return null;
            }

            @Override
            public Result removeFna(ApiAppointmentRemoveFnaRequest request) {
                return null;
            }

            @Override
            public Result editProposal(ApiAppointmentEditProposalRequest request) {
                return null;
            }

            @Override
            public Result removeProposal(ApiAppointmentRemoveProposalRequest request) {
                return null;
            }

            @Override
            public Result editPolicyTransfer(ApiPolicyTransferRequest request) {
                return null;
            }

            @Override
            public Result del(String appointmentBizId) {
                return null;
            }
        };
    }
}
