package com.yd.csf.feign.fallback.conditionconfig;

import com.yd.common.result.Result;
import com.yd.csf.feign.client.conditionconfig.ApiConditionConfigFeignClient;
import com.yd.csf.feign.request.conditionconfig.ApiConditionConfigAddRequest;
import com.yd.csf.feign.request.conditionconfig.ApiConditionConfigEditRequest;
import com.yd.csf.feign.request.conditionconfig.ApiConditionConfigPageRequest;
import com.yd.csf.feign.response.conditionconfig.ApiConditionConfigDetailResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * 香港保险服务-条件配置信息Feign降级处理
 */
@Slf4j
@Component
public class ApiConditionConfigFeignFallbackFactory implements FallbackFactory<ApiConditionConfigFeignClient> {

    @Override
    public ApiConditionConfigFeignClient create(Throwable cause) {
        return new ApiConditionConfigFeignClient() {
            @Override
            public Result page(ApiConditionConfigPageRequest request) {
                return null;
            }

            @Override
            public Result<ApiConditionConfigDetailResponse> detail(String conditionBizId) {
                return null;
            }

            @Override
            public Result add(ApiConditionConfigAddRequest request) {
                return null;
            }

            @Override
            public Result edit(ApiConditionConfigEditRequest request) {
                return null;
            }

            @Override
            public Result del( String conditionBizId) {
                return null;
            }
        };
    }
}
