package com.yd.csf.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.csf.api.service.ApiTeamService;
import com.yd.csf.feign.client.team.ApiTeamFeignClient;
import com.yd.csf.feign.request.team.ApiTeamListRequest;
import com.yd.csf.feign.request.team.ApiTeamPageRequest;
import com.yd.csf.feign.response.team.ApiTeamDetailResponse;
import com.yd.csf.feign.response.team.ApiTeamPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import java.util.List;

/**
 * 团队信息
 *
 * @author zxm
 * @since 2025-10-15
 */
@RestController
@RequestMapping("/team")
@Validated
public class ApiTeamController implements ApiTeamFeignClient {

    @Autowired
    private ApiTeamService apiTeamService;

    /**
     * 分页列表查询-团队信息
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiTeamPageResponse>> page(ApiTeamPageRequest request) {
        return apiTeamService.page(request);
    }

    /**
     * 列表查询-团队信息
     * @param request
     * @return
     */
    @Override
    public Result<List<ApiTeamDetailResponse>> list(ApiTeamListRequest request) {
        return apiTeamService.list(request);
    }

}
