package com.yd.csf.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 产品计划-附加险信息表
 * </p>
 *
 * @author zxm
 * @since 2025-12-24
 */
@Getter
@Setter
@TableName("additional")
public class Additional implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 附加险信息表唯一业务ID
     */
    @TableField("additional_biz_id")
    private String additionalBizId;

    /**
     * 产品计划信息表唯一业务ID
     */
    @TableField("plan_biz_id")
    private String planBizId;

    /**
     * 产品上架信息表唯一业务ID
     */
    @TableField("product_launch_biz_id")
    private String productLaunchBizId;

    /**
     * 产品上架信息表名称（标题）
     */
    @TableField("product_launch_name")
    private String productLaunchName;

    /**
     * 付款频率（字典）
     */
    @TableField("payment_frequency")
    private String paymentFrequency;

    /**
     * 供款期数
     */
    @TableField("issue_number")
    private String issueNumber;

    /**
     * 保障年期
     */
    @TableField("guarantee_period")
    private String guaranteePeriod;

    /**
     * 保单币种
     */
    @TableField("policy_currency")
    private String policyCurrency;

    /**
     * 保单额度（重疾）
     */
    @TableField("sum_insured")
    private BigDecimal sumInsured;

    /**
     * 每期保费
     */
    @TableField("each_issue_premium")
    private BigDecimal eachIssuePremium;

    /**
     * 保障级别
     */
    @TableField("protection_level")
    private String protectionLevel;

    /**
     * 保障地区（字典）
     */
    @TableField("guarantee_region")
    private String guaranteeRegion;

    /**
     * 自付额（字典）
     */
    @TableField("deductibles")
    private String deductibles;

    /**
     * 附加保障（json串）
     */
    @TableField("additional_safeguards")
    private String additionalSafeguards;

    /**
     * 保单征费
     */
    @TableField("policy_levy")
    private BigDecimal policyLevy;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
