package com.yd.csf.service.dto;

import com.alibaba.excel.annotation.ExcelProperty;
import com.yd.csf.service.model.Fortune;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Data
public class FortuneAccountExportDTO implements Serializable {
    private static final long serialVersionUID = 1L;

    @ExcelProperty("转介人")
    private String broker;

    @ExcelProperty("所属团队")
    private String team;

    @ExcelProperty("出账币种")
    private String currency;

    @ExcelProperty("出账总额")
    private BigDecimal amount;

    private List<Fortune> fortuneList;

    // 动态字段，用于存储不同的fortune项目
    private Map<String, BigDecimal> fortuneAmounts = new HashMap<>();

    // 添加fortune项目金额
    public void addFortuneAmount(String fortuneName, BigDecimal amount) {
        fortuneAmounts.put(fortuneName, amount);
    }

    // 获取fortune项目金额
    public BigDecimal getFortuneAmount(String fortuneName) {
        return fortuneAmounts.getOrDefault(fortuneName, BigDecimal.ZERO);
    }
}
