package com.yd.csf.feign.request.appointment;

import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 预约编辑关联FNA入参
 */
@Data
public class ApiAppointmentEditFnaRequest {

    /**
     * 预约信息主表唯一业务ID
     */
    @NotBlank(message = "预约信息主表唯一业务ID不能为空")
    private String appointmentBizId;

    /**
     * FNA表的业务id（FNA编号）
     */
    @NotBlank(message = "FNA表的业务id不能为空")
    private String fnaBizId;

    /**
     * FNA编号（和FNA信息表唯一业务ID是一对，唯一，冗余字段）
     */
    @NotBlank(message = "FNA编号id不能为空")
    private String fnaNo;
}
