package com.yd.csf.api.service.impl;

import com.yd.common.result.Result;
import com.yd.csf.api.service.ApiRelObjectSqlService;
import com.yd.csf.feign.dto.sqltemplate.ApiCommissionSqlTemplateDto;
import com.yd.csf.feign.dto.sqltemplate.ApiRelObjectSqlDto;
import com.yd.csf.service.dto.CommissionSqlTemplateDto;
import com.yd.csf.service.dto.RelObjectSqlDto;
import com.yd.csf.service.model.CommissionSqlTemplate;
import com.yd.csf.service.model.RelObjectSql;
import com.yd.csf.service.service.ICommissionSqlTemplateService;
import com.yd.csf.service.service.IRelObjectSqlService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Service
public class ApiRelObjectSqlServiceImpl implements ApiRelObjectSqlService {

    @Autowired
    private IRelObjectSqlService iRelObjectSqlService;

    @Autowired
    private ICommissionSqlTemplateService iCommissionSqlTemplateService;

    @Override
    public Result saveRelList(ApiRelObjectSqlDto dto) {
        //先删后新增
        RelObjectSqlDto relObjectSqlDto = new RelObjectSqlDto();
        BeanUtils.copyProperties(dto,relObjectSqlDto);
        iRelObjectSqlService.del(relObjectSqlDto);

        //新增
        if (!CollectionUtils.isEmpty(dto.getSqlTemplateBizIdList())) {
            List<RelObjectSql> saveList = dto.getSqlTemplateBizIdList().stream().map(bizId -> {
                RelObjectSql relObjectSql = new RelObjectSql();
                BeanUtils.copyProperties(dto,relObjectSql);
                relObjectSql.setSqlTemplateBizId(bizId);
                return relObjectSql;
            }).collect(Collectors.toList());
            iRelObjectSqlService.saveOrUpdateBatch(saveList);
        }
        return Result.success();
    }

    /**
     * 根据对象关系查询SQL模板配置列表信息
     * @param dto
     * @return
     */
    @Override
    public Result<List<ApiCommissionSqlTemplateDto>> apiCommissionSqlTemplateDtoList(ApiRelObjectSqlDto dto) {
        List<ApiCommissionSqlTemplateDto> apiCommissionSqlTemplateDtoList = new ArrayList<>();
        RelObjectSqlDto relObjectSqlDto = new RelObjectSqlDto();
        BeanUtils.copyProperties(dto,relObjectSqlDto);
        List<RelObjectSql> relObjectSqlList = iRelObjectSqlService.queryList(relObjectSqlDto);
        if (!CollectionUtils.isEmpty(relObjectSqlList)) {
            List<String> sqlTemplateBizIdList = relObjectSqlList.stream().map(RelObjectSql::getSqlTemplateBizId).collect(Collectors.toList());
            List<CommissionSqlTemplate> commissionSqlTemplateList = iCommissionSqlTemplateService.queryList(CommissionSqlTemplateDto.builder()
                    .sqlTemplateBizIdList(sqlTemplateBizIdList)
                    .build());
            if (!CollectionUtils.isEmpty(commissionSqlTemplateList)) {
                apiCommissionSqlTemplateDtoList = commissionSqlTemplateList.stream().map(d -> {
                    ApiCommissionSqlTemplateDto sqlTemplateDto = new ApiCommissionSqlTemplateDto();
                    BeanUtils.copyProperties(d,sqlTemplateDto);
                    return sqlTemplateDto;
                }).collect(Collectors.toList());
            }
        }
        return Result.success(apiCommissionSqlTemplateDtoList);
    }
}
