package com.yd.csf.feign.request.expectedfortune;

import com.yd.common.dto.PageDto;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.time.LocalDate;

@Data
public class ApiExpectedFortunePageRequest extends PageDto {
    /**
     * 保单号
     */
    @Schema(description = "保单号")
    private String policyNo;

    @Schema(description = "预估发佣开始日期")
    private LocalDate payoutDateStart;

    @Schema(description = "预估发佣结束日期")
    private LocalDate payoutDateEnd;

    @Schema(description = "发佣状态 0=待出账 1=可出帐 2=完成出账 3=部分出账 4=保留 5=已失效")
    private String status;

    /**
     * 发佣期数(1=第一年; 2=第二年; 3=第三年; 4=第四年; 5=第五年)
     */
    @Schema(description = "发佣期数(1=第一年; 2=第二年; 3=第三年; 4=第四年; 5=第五年)")
    private Integer fortunePeriod;

    @Schema(description = "发佣名称")
    private String fortuneName;

    @Schema(description = "出单团队")
    private String team;

    @Schema(description = "保险公司")
    private String insuranceCompany;

    @Schema(description = "产品名称")
    private String productName;

    /**
     * 转介人名称
     */
    @Schema(description = "转介人名称")
    private String broker;

    @Schema(description = "签单员名称")
    private String signer;

}
