package com.yd.csf.feign.response.expectedfortune;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

@Data
public class ApiExpectedFortunePageResponse {

    /**
     * 主键ID
     */
    @Schema(description = "expected fortune id")
    private Long id;

    /**
     * 预计发佣表唯一业务id
     */
    @Schema(description = "expected fortune biz id")
    private String expectedFortuneBizId;

    /**
     * 保单号
     */
    @Schema(description = "policy no")
    private String policyNo;

    /**
     * 发佣期数(1=第一年; 2=第二年; 3=第三年; 4=第四年; 5=第五年)
     */
    @Schema(description = "fortune period")
    private Integer fortunePeriod;

    /**
     * 发佣总期数
     */
    @Schema(description = "fortune total period")
    private Integer fortuneTotalPeriod;

    /**
     * 转介人名称
     */
    @Schema(description = "转介人名称")
    private String broker;

    /**
     * 转介人业务ID
     */
    @Schema(description = "broker biz id")
    private String brokerBizId;

    /**
     * 团队名称
     */
    @Schema(description = "团队名称")
    private String team;

    /**
     * 所属团队业务ID
     */
    @Schema(description = "所属团队 biz id")
    private String teamBizId;

    /**
     * 发佣名称
     */
    @Schema(description = "发佣名称")
    private String fortuneName;

    /**
     * 发佣类型
     */
    @Schema(description = "发佣类型")
    private String fortuneType;

    /**
     * 预计应发金额
     */
    @Schema(description = "预计应发金额")
    private BigDecimal amount;

    /**
     * 发佣币种
     */
    @Schema(description = "发佣币种")
    private String currency;

    /**
     * 发佣状态 0=待出账 1=可出帐 2=完成出账 3=部分出账 4=保留 5=已失效
     */
    @Schema(description = "发佣状态 0=待出账 1=可出帐 2=完成出账 3=部分出账 4=保留 5=已失效")
    private String status;

    /**
     * 预计发佣日期
     */
    @Schema(description = "预计发佣日期")
    private LocalDate payoutDate;

    /**
     * 已出账金额
     */
    @Schema(description = "已出账金额")
    private BigDecimal paidAmount;

    /**
     * 待出账金额
     */
    @Schema(description = "待出账金额")
    private BigDecimal unpaidAmount;

    /**
     * 发佣比例 已发佣金额/应发佣金额
     */
    @Schema(description = "发佣比例 已发佣金额/应发佣金额")
    private BigDecimal paidRatio;

    /**
     * 基本法项目配置表唯一业务ID
     */
    @Schema(description = "rule item biz id")
    private String ruleItemBizId;

    /**
     * 创建时间
     */
    @Schema(description = "create time")
    private LocalDateTime createTime;

}
