package com.yd.csf.service.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class PolicySecondHolderUpdateRequest implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 第二持有人业务ID
     */
    @Schema(description = "第二持有人业务ID", requiredMode = Schema.RequiredMode.REQUIRED)
    private String policySecondHolderBizId;

    /**
     * 保单号
     */
    @Schema(description = "保单号")
    private String policyNo;

    /**
     * 与受保人关系（字典）
     */
    @Schema(description = "与受保人关系（字典）")
    private String insurantRel;

    /**
     * 名字
     */
    @Schema(description = "名字")
    private String name;

    /**
     * 名字-英文
     */
    @Schema(description = "名字-英文")
    private String nameEn;

    /**
     * 性别（字典）
     */
    @Schema(description = "性别（字典）")
    private String gender;

    /**
     * 证件类型（字典）
     */
    @Schema(description = "证件类型（字典）")
    private String documentType;

    /**
     * 证件号码
     */
    @Schema(description = "证件号码")
    private String idNumber;

    /**
     * 护照号码
     */
    @Schema(description = "护照号码")
    private String passportNumber;

    /**
     * 出生日期
     */
    @Schema(description = "出生日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date birthTime;

    /**
     * 年龄
     */
    @Schema(description = "年龄")
    private String age;

    /**
     * 通用备注
     */
    @Schema(description = "通用备注")
    private String remark;
}
