package com.yd.csf.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 基本法项目配置表
 * </p>
 *
 * @author zxm
 * @since 2025-10-17
 */
@Getter
@Setter
@TableName("rule_item_config")
public class RuleItemConfig implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 基本法项目配置表唯一业务ID
     */
    @TableField("rule_item_biz_id")
    private String ruleItemBizId;

    /**
     * 基本法配置表唯一业务ID
     */
    @TableField("rule_biz_id")
    private String ruleBizId;

    /**
     * 基本法项目编码
     */
    @TableField("item_code")
    private String itemCode;

    /**
     * 基本法项目名称
     */
    @TableField("item_name")
    private String itemName;

    /**
     * 计算时间点（字典）
     */
    @TableField("calculate")
    private String calculate;

    /**
     * 执行顺序，数值越小越先执行，用于控制佣金项目的计算顺序
     */
    @TableField("execution_order")
    private Integer executionOrder;

    /**
     * 项目描述
     */
    @TableField("description")
    private String description;

    /**
     * 状态(0:停用 1:启用)
     */
    @TableField("status")
    private Integer status;

    /**
     * 所属租户唯一业务ID（冗余）
     */
    @TableField("tenant_biz_id")
    private String tenantBizId;

    /**
     * 所属项目唯一业务ID（冗余）
     */
    @TableField("project_biz_id")
    private String projectBizId;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
