package com.yd.csf.feign.fallback.appointmentfile;

import com.yd.common.result.Result;
import com.yd.csf.feign.client.appointmentfile.ApiAppointmentFileFeignClient;
import com.yd.csf.feign.request.appointmentfile.ApiAppointmentFileAddRequest;
import com.yd.csf.feign.request.appointmentfile.ApiAppointmentFileEditRequest;
import com.yd.csf.feign.request.appointmentfile.ApiAppointmentFilePageRequest;
import com.yd.csf.feign.request.appointmentfile.ApiAppointmentImportExcelRequest;
import com.yd.csf.feign.response.appointmentfile.ApiAppointmentImportExcelResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.constraints.NotBlank;

/**
 * 香港保险服务-预约附件信息Feign降级处理
 */
@Slf4j
@Component
public class ApiAppointmentFileFeignFallbackFactory implements FallbackFactory<ApiAppointmentFileFeignClient> {
    @Override
    public ApiAppointmentFileFeignClient create(Throwable cause) {
        return new ApiAppointmentFileFeignClient() {
            @Override
            public Result page(ApiAppointmentFilePageRequest request) {
                return null;
            }

            @Override
            public Result add(ApiAppointmentFileAddRequest request) {
                return null;
            }

            @Override
            public Result edit(ApiAppointmentFileEditRequest request) {
                return null;
            }

            @Override
            public Result del(String appointmentFileBizId) {
                return null;
            }

            @Override
            public Result download(String appointmentFileBizId) {
                return null;
            }

            @Override
            public Result<String> itineraryPdf(String appointmentBizId) {
                return null;
            }

            @Override
            public Result<String> appointmentExportExcel(String appointmentBizId) {
                return null;
            }

            @Override
            public Result<ApiAppointmentImportExcelResponse> appointmentImportExcel(MultipartFile file,
                                                                                    ApiAppointmentImportExcelRequest request) {
                return null;
            }
        };
    }
}
