package com.yd.csf.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yd.csf.service.model.AppointmentUserSign;
import com.yd.csf.service.dao.AppointmentUserSignMapper;
import com.yd.csf.service.service.IAppointmentUserSignService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 预约-签单员信息表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-12-15
 */
@Service
public class AppointmentUserSignServiceImpl extends ServiceImpl<AppointmentUserSignMapper, AppointmentUserSign> implements IAppointmentUserSignService {

    @Override
    public Boolean delByAppointmentBizId(String appointmentBizId) {
        return this.remove(new LambdaQueryWrapper<AppointmentUserSign>().eq(AppointmentUserSign::getAppointmentBizId,appointmentBizId));
    }
}
