package com.yd.csf.service.model;

import com.baomidou.mybatisplus.annotation.*;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 产品计划信息表
 * </p>
 *
 * @author zxm
 * @since 2025-09-01
 */
@Getter
@Setter
@TableName("product_plan")
public class ProductPlan implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 预约信息主表唯一业务ID
     */
    @TableField("appointment_biz_id")
    private String appointmentBizId;

    /**
     * 产品计划信息表唯一业务ID
     */
    @TableField("plan_biz_id")
    private String planBizId;

    /**
     * 保险产品唯一业务ID（中台保险产品业务id，冗余）
     */
    @TableField("product_biz_id")
    private String productBizId;

    /**
     * 保险产品名称（中台保险产品名称，冗余）
     */
    @TableField("product_name")
    private String productName;

    /**
     * 保险公司名称（冗余字段）
     */
    @TableField("company_name")
    private String companyName;

    /**
     * 地区（冗余字段）
     */
    @TableField("region")
    private String region;

    /**
     * 货币（字典）
     */
    @TableField("currency")
    private String currency;

    /**
     * 供款年期（字典）
     */
    @TableField("payment_term")
    private String paymentTerm;

    /**
     * 付款频率（字典）
     */
    @TableField("payment_frequency")
    private String paymentFrequency;

    /**
     * 每期保费
     */
    @TableField("each_issue_premium")
    private BigDecimal eachIssuePremium;

    /**
     * 保额
     */
    @TableField("sum_insured")
    private BigDecimal sumInsured;

    /**
     * 是否预缴保费: 0-否, 1-是（字典）
     */
    @TableField("is_prepay")
    private Integer isPrepay;

    /**
     * 预付额
     */
    @TableField("deductibles")
    private BigDecimal deductibles;

    /**
     * 首期付款方式（字典）
     */
    @TableField("initial_payment_method")
    private String initialPaymentMethod;

    /**
     * 续期付款方式（字典）
     */
    @TableField("renewal_payment_method")
    private String renewalPaymentMethod;

    /**
     * 红利分配方式（字典）
     */
    @TableField("dividend_distribution_method")
    private String dividendDistributionMethod;

    /**
     * 保单日期回溯: 0-否, 1-是（字典）
     */
    @TableField("is_backtrack")
    private Integer isBacktrack;

    /**
     * 保单生效日
     */
    @TableField(value = "policy_effective_date",updateStrategy = FieldStrategy.IGNORED)
    private LocalDateTime policyEffectiveDate;

    /**
     * 是否参加递增保障权益: 0-否, 1-是（字典）
     */
    @TableField("is_join")
    private Integer isJoin;

    /**
     * 保单征费
     */
    @TableField("policy_levy")
    private BigDecimal policyLevy;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
