package com.yd.csf.feign.request.expectedfortune;

import com.yd.common.dto.PageDto;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.time.LocalDate;
import java.util.List;

@Data
public class ApiExpectedFortunePageRequest extends PageDto {
    /**
     * 保单号
     */
    @Schema(description = "保单号")
    private String policyNo;

    @Schema(description = "预估发佣开始日期")
    private LocalDate payoutDateStart;

    @Schema(description = "预估发佣结束日期")
    private LocalDate payoutDateEnd;

    @Schema(description = "出账状态, 可多选 0=待出账 1=可出帐 2=完成出账 3=部分出账 4=保留 5=已失效")
    private List<String> statusList;

    /**
     * 发佣期数(1=第一年; 2=第二年; 3=第三年; 4=第四年; 5=第五年)
     */
    @Schema(description = "出账期数(1=第一年; 2=第二年; 3=第三年; 4=第四年; 5=第五年)")
    private Integer fortunePeriod;

    @Schema(description = "出账项目")
    private String fortuneName;

    @Schema(description = "出单团队名称")
    private String team;

    @Schema(description = "出单团队业务ID")
    private String teamBizId;

    @Schema(description = "保险公司")
    private String insuranceCompany;

    @Schema(description = "产品名称")
    private String productName;

    @Schema(description = "产品计划：产品上架信息业务ID")
    private String productLaunchBizId;

    /**
     * 转介人名称
     */
    @Schema(description = "转介人名称")
    private String broker;

    @Schema(description = "签单员名称")
    private String signer;

    @Schema(description = "应付款类型 R-关联保单应付款 U-非关联保单应付款")
    private String fortuneBizType;
}
