package com.yd.csf.api.service.impl;

import com.yd.common.result.Result;
import com.yd.csf.api.service.ApiRelObjectConditionService;
import com.yd.csf.feign.dto.conditionconfig.ApiRelObjectConditionDto;
import com.yd.csf.feign.dto.conditionconfig.ApiConditionTypeDto;
import com.yd.csf.service.dto.ConditionTypeDto;
import com.yd.csf.service.dto.RelObjectConditionDto;
import com.yd.csf.service.model.*;
import com.yd.csf.service.service.IConditionTypeService;
import com.yd.csf.service.service.IRelObjectConditionService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Service
public class ApiRelObjectConditionServiceImpl implements ApiRelObjectConditionService {

    @Autowired
    private IRelObjectConditionService iRelObjectConditionService;

    @Autowired
    private IConditionTypeService iConditionTypeService;

    /**
     * 保存对象和规则条件配置关系
     * @param dto
     * @return
     */
    @Override
    public Result saveRelList(ApiRelObjectConditionDto dto) {
        //先删后新增
        iRelObjectConditionService.del(dto);

        //新增
        if (!CollectionUtils.isEmpty(dto.getConditionTypeBizIdList())) {
            List<RelObjectCondition> saveList = dto.getConditionTypeBizIdList().stream().map(conditionTypeBizId -> {
                RelObjectCondition relObjectCondition = new RelObjectCondition();
                BeanUtils.copyProperties(dto,relObjectCondition);
                relObjectCondition.setConditionTypeBizId(conditionTypeBizId);
                return relObjectCondition;
            }).collect(Collectors.toList());
            iRelObjectConditionService.saveOrUpdateBatch(saveList);
        }
        return Result.success();
    }

    /**
     * 根据对象关系查询条件类型列表信息
     * @param dto
     * @return
     */
    @Override
    public Result<List<ApiConditionTypeDto>> apiConditionTypeDtoList(ApiRelObjectConditionDto dto) {
        List<ApiConditionTypeDto> apiConditionTypeDtoList = new ArrayList<>();
        RelObjectConditionDto relObjectConditionDto = new RelObjectConditionDto();
        BeanUtils.copyProperties(dto,relObjectConditionDto);
        List<RelObjectCondition> relObjectConditionList = iRelObjectConditionService.queryList(relObjectConditionDto);
        if (!CollectionUtils.isEmpty(relObjectConditionList)) {
            List<String> conditionTypeBizIdList = relObjectConditionList.stream().map(RelObjectCondition::getConditionTypeBizId).collect(Collectors.toList());
            List<ConditionType> conditionTypeList = iConditionTypeService.queryList(ConditionTypeDto.builder()
                    .conditionTypeBizIdList(conditionTypeBizIdList)
                    .build());
            if (!CollectionUtils.isEmpty(conditionTypeList)) {
                apiConditionTypeDtoList = conditionTypeList.stream().map(d -> {
                    ApiConditionTypeDto typeDto = new ApiConditionTypeDto();
                    BeanUtils.copyProperties(d,typeDto);
                    return typeDto;
                }).collect(Collectors.toList());
            }
        }
        return Result.success(apiConditionTypeDtoList);
    }

}
