package com.yd.csf.service.dto;

import com.yd.common.dto.PageDto;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.util.Date;

@Data
public class CommissionExpectedQueryRequest extends PageDto {
    /**
     * 保单号
     */
    @Schema(description = "保单号")
    private String policyNo;

    /**
     * 来佣状态 0=待来佣 1=已来佣 2=部分来佣
     */
    @Schema(description = "来佣状态 0=待来佣 1=已来佣 2=部分来佣")
    private String status;

    /**
     * 预计来佣日期 格式：yyyy-MM-dd 查询该日期及之前的预计来佣记录
     */
    @Schema(description = "预计来佣日期 格式：yyyy-MM-dd 查询该日期及之前的预计来佣记录")
    private Date commissionDate;
}
