package com.yd.csf.feign.request.premiumreconciliation;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.yd.common.dto.PageDto;
import com.yd.common.utils.CustomLocalDateTimeDeserializer;
import lombok.Data;
import java.time.LocalDateTime;

@Data
public class ApiPremiumReconciliationPageRequest extends PageDto {

    /**
     * 保险公司业务id
     */
    private String insuranceCompanyBizId;

    /**
     * 付款银行
     */
    private String payingBank;

    /**
     * 付款人
     */
    private String payer;

    /**
     * 保单号
     */
    private String policyNo;

    /**
     * 预约编号
     */
    private String appointmentNo;

    /**
     * 保單持有人（投保人）
     */
    private String policyHolder;

    /**
     * 缴费方式
     */
    private String paymentMethod;

    /**
     * 新单跟进状态
     */
    private String policyFollowStatus;

    /**
     * 保单状态
     */
    private String policyStatus;

    /**
     * 对账类型
     */
    private String reconciliationType;

    /**
     * 付款日期
     */
    @JsonDeserialize(using = CustomLocalDateTimeDeserializer.class)
    private LocalDateTime paymentDate;
}
