package com.yd.csf.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yd.common.enums.ResultCode;
import com.yd.common.exception.BusinessException;
import com.yd.csf.service.dto.PolicyInsurantUpdateRequest;
import com.yd.csf.service.model.PolicyInsurant;
import com.yd.csf.service.service.PolicyInsurantService;
import com.yd.csf.service.dao.PolicyInsurantMapper;
import com.yd.csf.service.utils.GSONUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import java.util.Date;

/**
* @author Zhang Jianan
* @description 针对表【policy_insurant(保单受保人信息表)】的数据库操作Service实现
* @createDate 2025-10-31 13:29:18
*/
@Service
public class PolicyInsurantServiceImpl extends ServiceImpl<PolicyInsurantMapper, PolicyInsurant>
    implements PolicyInsurantService{

    @Override
    public boolean update(PolicyInsurantUpdateRequest policyInsurantUpdateRequest) {
        if (policyInsurantUpdateRequest == null || StringUtils.isBlank(policyInsurantUpdateRequest.getPolicyInsurantBizId())) {
            throw new BusinessException(ResultCode.PARAMS_ERROR.getCode(), "policyInsurantBizId不能为空");
        }
        PolicyInsurant policyInsurant = this.getOne(new QueryWrapper<PolicyInsurant>().eq("policy_insurant_biz_id", policyInsurantUpdateRequest.getPolicyInsurantBizId()));
        if (policyInsurant == null) {
            throw new BusinessException(ResultCode.NULL_ERROR.getCode(), ResultCode.NULL_ERROR.getMessage());
        }
        BeanUtils.copyProperties(policyInsurantUpdateRequest, policyInsurant, "policyBizId", "policyInsurantBizId", "id");
        // 处理地址Json
        if (CollectionUtils.isNotEmpty(policyInsurantUpdateRequest.getAddressList())) {
            policyInsurant.setAddressList(GSONUtil.toJson(policyInsurantUpdateRequest.getAddressList()));
        }
        policyInsurant.setUpdateTime(new Date());
        return this.updateById(policyInsurant);
    }
}




