package com.yd.csf.service.dto;

import com.google.gson.reflect.TypeToken;
import com.yd.csf.service.model.*;
import com.yd.csf.service.utils.GSONUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * 新单跟进聚合查询结果DTO
 */
@Data
public class PolicyFollowAggregateDto implements Serializable {
    /**
     * 新单跟进业务ID
     */
    @Schema(description = "新单跟进业务ID")
    private String policyBizId;

     /**
     * 客户业务ID
     */
    @Schema(description = "客户业务ID")
    private String customerBizId;

     /**
     * 问卷业务ID
     */
    @Schema(description = "问卷业务ID 新单跟进问卷中，objectBizId为policyBizId")
    private String questionnaireBizId;

    /**
     * 保单产品计划（保单）
     */
    @Schema(description = "保单产品计划（保单）")
    private PolicyDto apiProductPlanInfoDto;

    /**
     * 保单投保人
     */
    @Schema(description = "保单投保人")
    private PolicyPolicyholder apiPolicyholderInfoDto;

    /**
     * 保单受保人
     */
    @Schema(description = "保单受保人")
    private PolicyInsurant apiInsurantInfoDto;

    /**
     * 保单受益人
     */
    @Schema(description = "保单受益人")
    private List<PolicyBeneficiary> apiBeneficiaryInfoDtoList;

    /**
     * 保单第二持有人
     */
    @Schema(description = "保单第二持有人")
    private PolicySecondHolder apiSecondHolderInfoDto;

    // 错误信息（如果有查询失败的情况）
    private String errorMessage;

    private static final long serialVersionUID = 1L;


    public static PolicyFollowAggregateDto convertToDto(Policy policy,
                                                        List<PolicyAdditional> policyAdditionals,
                                                        PolicyPolicyholder policyPolicyholder,
                                                        PolicyInsurant policyInsurant,
                                                        List<PolicyBeneficiary> beneficiaryList,
                                                        PolicySecondHolder policySecondHolder) {
        PolicyFollowAggregateDto dto = new PolicyFollowAggregateDto();
        if (ObjectUtils.isEmpty(policy)) {
            return dto;
        }

        // 设置保单产品计划（保单）
        if (ObjectUtils.isNotEmpty(policy)) {
            PolicyDto apiProductPlanInfoDto = new PolicyDto();
            // 产品计划主信息
            apiProductPlanInfoDto.setApiProductPlanMainInfoDto(policy);

            // 附加险列表
            apiProductPlanInfoDto.setApiProductPlanAdditionalInfoDtoList(policyAdditionals);
            dto.setApiProductPlanInfoDto(apiProductPlanInfoDto);
        }
        // 设置保单投保人
        if (ObjectUtils.isNotEmpty(policyPolicyholder)) {
            policyPolicyholder.setAddressList(GSONUtil.fromJson((String) policyPolicyholder.getAddressList(), new TypeToken<List<Map<String, Object>>>() {}.getType()));
            dto.setApiPolicyholderInfoDto(policyPolicyholder);
        }
        // 设置保单受保人
        if (ObjectUtils.isNotEmpty(policyInsurant)) {
            policyInsurant.setAddressList(GSONUtil.fromJson((String) policyInsurant.getAddressList(), new TypeToken<List<Map<String, Object>>>() {}.getType()));
            dto.setApiInsurantInfoDto(policyInsurant);
        }
        // 设置保单受益人
        if (CollectionUtils.isNotEmpty(beneficiaryList)) {
            beneficiaryList.forEach(beneficiary -> {
                beneficiary.setAddressList(GSONUtil.fromJson((String) beneficiary.getAddressList(), new TypeToken<List<Map<String, Object>>>() {}.getType()));
            });
            dto.setApiBeneficiaryInfoDtoList(beneficiaryList);
        }
        // 设置保单第二持有人
        if (ObjectUtils.isNotEmpty(policySecondHolder)) {
            dto.setApiSecondHolderInfoDto(policySecondHolder);
        }

        return dto;
    }
}