package com.yd.csf.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yd.csf.service.dto.BeneficiaryDto;
import com.yd.csf.service.model.Additional;
import com.yd.csf.service.model.Beneficiary;
import com.yd.csf.service.dao.BeneficiaryMapper;
import com.yd.csf.service.service.IBeneficiaryService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;

/**
 * <p>
 * 受益人信息主表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-09-01
 */
@Service
public class BeneficiaryServiceImpl extends ServiceImpl<BeneficiaryMapper, Beneficiary> implements IBeneficiaryService {

    /**
     * 查询列表
     * @param dto
     * @return
     */
    @Override
    public List<Beneficiary> queryList(BeneficiaryDto dto) {
        List<Beneficiary> list = baseMapper.selectList(new LambdaQueryWrapper<Beneficiary>()
                .eq(StringUtils.isNotBlank(dto.getAppointmentBizId()),Beneficiary::getAppointmentBizId,dto.getAppointmentBizId())
                .in(!CollectionUtils.isEmpty(dto.getBeneficiaryBizIdList()),Beneficiary::getBeneficiaryBizId,dto.getBeneficiaryBizIdList())
        );
        return list;
    }

    /**
     * 查询单个对象
     * @param beneficiaryBizId
     * @return
     */
    @Override
    public Beneficiary queryOne(String beneficiaryBizId) {
        return this.getOne(new LambdaQueryWrapper<Beneficiary>().eq(Beneficiary::getBeneficiaryBizId,beneficiaryBizId));
    }

    @Override
    public Boolean del(String appointmentBizId) {
        return this.remove(new LambdaQueryWrapper<Beneficiary>().eq(Beneficiary::getAppointmentBizId,appointmentBizId));
    }
}
