package com.yd.csf.feign.client.beneficiary;

import com.yd.common.result.Result;
import com.yd.csf.feign.dto.appointment.ApiBeneficiaryInfoDto;
import com.yd.csf.feign.fallback.beneficiary.ApiBeneficiaryFeignFallbackFactory;
import com.yd.csf.feign.request.beneficiary.ApiBeneficiaryPageRequest;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * 香港保险服务-受益人信息Feign客户端
 */
@FeignClient(name = "yd-csf-api", fallbackFactory = ApiBeneficiaryFeignFallbackFactory.class)
public interface ApiBeneficiaryFeignClient {

    /**
     * 受益人信息分页查询
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@RequestBody ApiBeneficiaryPageRequest request);

    /**
     * 受益人信息列表查询
     * @param appointmentBizId
     * @return
     */
    @GetMapping("/list")
    Result<List<ApiBeneficiaryInfoDto>> list(@NotBlank(message = "预约信息主表唯一业务ID不能为空") @RequestParam(value = "appointmentBizId") String appointmentBizId);

    /**
     * 新增单个受益人信息
     * @param apiBeneficiaryInfoDto
     * @return
     */
    @PostMapping("/add")
    Result add(@Validated @RequestBody ApiBeneficiaryInfoDto apiBeneficiaryInfoDto);

    /**
     * 编辑单个受益人信息
     * @param apiBeneficiaryInfoDto
     * @return
     */
    @PutMapping("/edit")
    Result edit(@Validated @RequestBody ApiBeneficiaryInfoDto apiBeneficiaryInfoDto);

    /**
     * 删除单个受益人信息
     * @param beneficiaryBizId
     * @return
     */
    @DeleteMapping("/del")
    Result del(@NotBlank(message = "受益人信息表唯一业务ID不能为空") @RequestParam(value = "beneficiaryBizId") String beneficiaryBizId);
}
