package com.yd.csf.service.vo;

import com.yd.csf.service.model.Fna;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.springframework.beans.BeanUtils;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * fna视图
 *
 */
@Data
public class FnaVO implements Serializable {

    /**
     * id
     */
    @Schema(description = "id")
    private Long id;

    /**
     * fna唯一业务ID
     */
    @Schema(description = "fna业务ID")
    private String fnaBizId;

    /**
     * 流程编号
     */
    @Schema(description = "流程编号")
    private String fnaNo;

    /**
     * 系统用户唯一业务ID
     */
    @Schema(description = "系统用户唯一业务ID")
    private String userBizId;

    /**
     * 客户姓名
     */
    @Schema(description = "客户姓名")
    private String customerName;

    /**
     * 客户唯一业务ID
     */
    @Schema(description = "客户唯一业务ID")
    private String customerBizId;

    /**
     * Fna表单唯一业务ID
     */
    @Schema(description = "Fna表单唯一业务ID")
    private String fnaFormBizId;

    /**
     * FNA表单 状态
     */
    @Schema(description = "FNA表单 状态 'UNCOMPLETED'-未完成, 'COMPLETED'-已完成")
    private String fnaFormStatus;

    /**
     * 预约编号
     */
    @Schema(description = "预约编号")
    private String appointmentNo;

    /**
     * 预约信息主表唯一业务ID
     */
    @Schema(description = "预约信息主表唯一业务ID")
    private String appointmentBizId;

    /**
     * 新单跟进唯一业务ID
     */
    @Schema(description = "新单跟进唯一业务ID")
    private String policyBizId;

    /**
     * 保单编号
     */
    @Schema(description = "保单编号")
    private String policyNo;

    /**
     * FNA 状态
     */
    @Schema(description = "FNA 状态 'UNCOMPLETED'-未完成, 'COMPLETED'-已完成")
    private Object status;

    /**
     * 产品代码
     */
    @Schema(description = "产品代码")
    private String productCode;

    /**
     * 产品名称
     */
    @Schema(description = "产品名称")
    private String productName;

    /**
     * 相关URL
     */
    @Schema(description = "相关URL")
    private String url;

    /**
     * 是否可编辑: 0-否, 1-是
     */
    @Schema(description = "是否可编辑: '0'-否, '1'-是")
    private String edit;

    /**
     * 通用备注
     */
    @Schema(description = "通用备注")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @Schema(description = "删除标识: '0'-正常, '1'-删除")
    private String isDeleted;

    /**
     * 创建时间
     */
    @Schema(description = "创建时间")
    private Date createTime;

    /**
     * 封装类转对象
     *
     * @param fnaVO
     * @return
     */
    public static Fna voToObj(FnaVO fnaVO) {
        if (fnaVO == null) {
            return null;
        }
        Fna fna = new Fna();
        BeanUtils.copyProperties(fnaVO, fna);

        return fna;
    }

    /**
     * 对象转封装类
     *
     * @param fna
     * @return
     */
    public static FnaVO objToVo(Fna fna) {
        if (fna == null) {
            return null;
        }
        FnaVO fnaVO = new FnaVO();
        BeanUtils.copyProperties(fna, fnaVO);

        return fnaVO;
    }
}
