package com.yd.csf.service.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yd.common.dto.PageDto;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.util.Date;
import java.util.List;

@Data
public class CommissionExpectedQueryRequest extends PageDto {
    /**
     * 保单号
     */
    @Schema(description = "保单号")
    private String policyNo;

    /**
     * 入账状态 0=待入账 1=完成入账 2=部分入账 3=已失效 可多选
     */
    @Schema(description = "入账状态 0=待入账 1=完成入账 2=部分入账 3=已失效 可多选，字典值: csf_commission_expected_status")
    private List<String> statusList;

    /**
     * 预计入账日期开始 格式：yyyy-MM-dd
     */
    @Schema(description = "预计入账日期开始 格式：yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date commissionDateStart;

    /**
     * 预计入账日期结束 格式：yyyy-MM-dd
     */
    @Schema(description = "预计入账日期结束 格式：yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date commissionDateEnd;

    /**
     * 入账期数
     */
    @Schema(description = "入账期数")
    private Integer commissionPeriod;

    /**
     * 入账项目(1:销售拥金;2:销售奖金;3:销售津贴;4:续期佣金;5:服务津贴;等等)
     */
    @Schema(description = "入账项目(1:销售拥金;2:销售奖金;3:销售津贴;4:续期佣金;5:服务津贴;等等)")
    private String commissionName;

    /**
     * 对账公司业务ID列表
     */
    @Schema(description = "对账公司业务ID列表")
    private List<String> reconciliationCompanyBizIdList;

    /**
     * 保险公司业务ID列表
     */
    @Schema(description = "保险公司业务ID列表")
    private List<String> insurerCompanyBizIdList;

    /**
     * 产品上架信息表唯一业务ID
     */
    @Schema(description = "产品计划: 产品上架信息表唯一业务ID")
    private String productLaunchBizId;

    /**
     * 应收款类型 R=关联保单应收单 U=非关联保单应收单
     */
    @Schema(description = "应收款类型 R=关联保单应收单 U=非关联保单应收单")
    private String commissionBizType;

    /**
     * 转介人所属团队业务ID
     */
    @Schema(description = "转介人所属团队业务ID")
    private String teamBizId;
}
