package com.yd.csf.service.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;

/**
 * 更新fna请求
 *
 */
@Data
public class FnaUpdateRequest implements Serializable {

    /**
     * fna唯一业务ID
     */
    @Schema(description = "fna唯一业务ID", requiredMode = Schema.RequiredMode.REQUIRED)
    private String fnaBizId;

    /**
     * 客户唯一业务ID
     */
    @Schema(description = "客户唯一业务ID")
    private String customerBizId;

    /**
     * Fna Form唯一业务ID
     */
    @Schema(description = "Fna Form唯一业务ID")
    private String fnaFormBizId;

    /**
     * 预约信息唯一业务ID
     */
    @Schema(description = "预约信息唯一业务ID")
    private String appointmentBizId;

    /**
     * 新单编号
     */
    @Schema(description = "新单编号")
    private String policyId;

    /**
     * 保单号
     */
    @Schema(description = "保单号")
    private String policyNo;

    private static final long serialVersionUID = 1L;
}