package com.yd.csf.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 税务信息表
 * </p>
 *
 * @author zxm
 * @since 2025-12-17
 */
@Getter
@Setter
@TableName("taxation")
public class Taxation implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 税务信息表唯一业务ID
     */
    @TableField("taxation_biz_id")
    private String taxationBizId;

    /**
     * 对象类型
     */
    @TableField("object_type")
    private String objectType;

    /**
     * 对象所属表名（投保人表、受保人表等）
     */
    @TableField("object_table_name")
    private String objectTableName;

    /**
     * 对象名
     */
    @TableField("object_name")
    private String objectName;

    /**
     * 对象业务ID
     */
    @TableField("object_biz_id")
    private String objectBizId;

    /**
     * 税务国家
     */
    @TableField("tax_country")
    private String taxCountry;

    /**
     * 税务编号
     */
    @TableField("tax_id")
    private String taxId;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
