package com.yd.csf.api.dto;

import com.yd.csf.service.dto.CommissionBindPolicyBrokerDto;
import com.yd.csf.service.dto.QueryPolicyAndBrokerDto;
import com.yd.csf.service.model.Commission;
import com.yd.csf.service.model.CommissionRuleBinding;
import com.yd.csf.service.model.Policy;
import com.yd.csf.service.model.PolicyBroker;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class ExecuteBillingDto {

    /**
     * 获得积分的业务员（客户端用户表唯一业务ID）
     */
    private String clientUserBizId;

    /**
     * 获得积分的业务员姓名
     */
    private String name;

    /**
     * 出账的批次号
     */
    private String batchBizId;

    /**
     * 期数（数字代表第几年）
     */
    private Integer issueNumber;

    /**
     * 保单和转介人信息
     */
    private QueryPolicyAndBrokerDto policyAndBrokerDto;

    /**
     * 来佣绑定的保单和转介人(销售)信息封装
     */
    private CommissionBindPolicyBrokerDto brokerDto;
}
