package com.yd.csf.feign.enums;

/**
 * 付款频率枚举
 */
public enum PaymentFrequencyEnum {

    MONTH("月缴","MONTH"),
    SEASON("季缴","SEASON"),
    YEAR("年缴","YEAR"),
    FULL_PAYMENT("整付","FULL_PAYMENT"),
    ;
    //字典项标签（名称）
    private String itemLabel;
    //字典项值
    private String itemValue;

    //构造函数
    PaymentFrequencyEnum(String itemLabel, String itemValue) {
        this.itemLabel = itemLabel;
        this.itemValue = itemValue;
    }

    public String getItemLabel() {
        return itemLabel;
    }

    public String getItemValue() {
        return itemValue;
    }
}
