package com.yd.csf.feign.fallback.ruleItemconfig;

import com.yd.common.result.Result;
import com.yd.csf.feign.client.ruleItemconfig.ApiRuleItemConfigFeignClient;
import com.yd.csf.feign.request.ruleItemconfig.ApiRuleItemConfigAddRequest;
import com.yd.csf.feign.request.ruleItemconfig.ApiRuleItemConfigEditRequest;
import com.yd.csf.feign.request.ruleItemconfig.ApiRuleItemConfigPageRequest;
import com.yd.csf.feign.response.ruleItemconfig.ApiRuleItemConfigDetailResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * 香港保险服务-基本法项目配置信息Feign降级处理
 */
@Slf4j
@Component
public class ApiRuleItemConfigFeignFallbackFactory implements FallbackFactory<ApiRuleItemConfigFeignClient> {
    @Override
    public ApiRuleItemConfigFeignClient create(Throwable cause) {
        return new ApiRuleItemConfigFeignClient() {
            @Override
            public Result page(ApiRuleItemConfigPageRequest request) {
                return null;
            }

            @Override
            public Result<ApiRuleItemConfigDetailResponse> detail(String ruleItemBizId) {
                return null;
            }

            @Override
            public Result add(ApiRuleItemConfigAddRequest request) {
                return null;
            }

            @Override
            public Result edit(ApiRuleItemConfigEditRequest request) {
                return null;
            }

            @Override
            public Result del(String ruleItemBizId) {
                return null;
            }
        };
    }
}
