package com.yd.csf.service.vo;

import com.yd.csf.service.model.Customer;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.springframework.beans.BeanUtils;

import java.io.Serializable;
import java.util.Date;

/**
 * customer视图
 *
 */
@Data
public class CustomerVO implements Serializable {

    /**
     * id
     */
    @Schema(description = "id")
    private Long id;

    /**
     * 客户唯一业务ID
     */
    @Schema(description = "客户业务ID")
    private String customerBizId;

    /**
     * 自定义代码
     */
    @Schema(description = "客户自定义代码")
    private String customCode;

    /**
     * 姓氏
     */
    @Schema(description = "客户姓氏")
    private String lastName;

    /**
     * 名字
     */
    @Schema(description = "客户名字")
    private String firstName;

    /**
     * 姓名
     */
    @Schema(description = "客户姓名")
    private String name;

    /**
     * 姓氏拼音
     */
    @Schema(description = "客户姓氏拼音")
    private String lastNamePinyin;

    /**
     * 名字拼音
     */
    @Schema(description = "客户名字拼音")
    private String firstNamePinyin;

    /**
     * 拼音全称
     */
    @Schema(description = "客户拼音全称")
    private String pinyin;

    /**
     * 称谓
     */
    @Schema(description = "客户称谓")
    private String title;

    /**
     * 性别
     */
    @Schema(description = "性别")
    private Object gender;

    /**
     * 出生日期
     */
    @Schema(description = "出生日期")
    private String birthdate;

    /**
     * 异常信息
     */
    @Schema(description = "异常信息")
    private String abnormal;

    /**
     * 年龄
     */
    @Schema(description = "年龄")
    private String age;

    /**
     * 地区代码
     */
    @Schema(description = "地区代码")
    private String areaCode;

    /**
     * 电话号码
     */
    @Schema(description = "客户电话号码")
    private String phone;

    /**
     * 电子邮箱
     */
    @Schema(description = "客户电子邮箱")
    private String email;

    /**
     * 是否吸烟
     */
    @Schema(description = "是否吸烟 'NS'-不吸烟 'S'-吸烟 ")
    private String smoke;

    /**
     * 吸烟数量
     */
    @Schema(description = "吸烟数量")
    private String smokeQuantity;

    /**
     * 公司类型
     */
    @Schema(description = "公司类型")
    private String companyType;

    /**
     * 来源
     */
    @Schema(description = "客户来源")
    private String source;

    /**
     * 证件类型
     */
    @Schema(description = "证件类型")
    private String idType;

    /**
     * 证件号码
     */
    @Schema(description = "证件号码")
    private String idCard;

    /**
     * 护照号
     */
    @Schema(description = "护照号")
    private String passport;

    /**
     * 往来港澳通行证号码
     */
    @Schema(description = "往来港澳通行证号码")
    private String eepCode;

    /**
     * 婚姻状况
     */
    @Schema(description = "婚姻状况")
    private Object marriage;

    /**
     * 出生地
     */
    @Schema(description = "出生地")
    private String birthplace;

    /**
     * 教育程度
     */
    @Schema(description = "教育程度")
    private Object education;

    /**
     * 签单用户扩展唯一业务ID
     */
    @Schema(description = "客户扩展信息ID")
    private String customerExpandBizId;

    /**
     * 国家
     */
    @Schema(description = "国家")
    private String country;

    /**
     * 创建时间
     */
    @Schema(description = "创建时间")
    private Date createTime;

    /**
     * 客户扩展信息
     */
    private CustomerExpandVO customerExpand;

    /**
     * 封装类转对象
     *
     * @param customerVO
     * @return
     */
    public static Customer voToObj(CustomerVO customerVO) {
        if (customerVO == null) {
            return null;
        }
        Customer customer = new Customer();
        BeanUtils.copyProperties(customerVO, customer);

        return customer;
    }

    /**
     * 对象转封装类
     *
     * @param customer
     * @return
     */
    public static CustomerVO objToVo(Customer customer) {
        if (customer == null) {
            return null;
        }
        CustomerVO customerVO = new CustomerVO();
        BeanUtils.copyProperties(customer, customerVO);

        return customerVO;
    }
}
