package com.yd.csf.service.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
public class CommissionAddDto implements Serializable {
    /**
     * 来佣名称(1:销售拥金;2:销售奖金;3:销售津贴;4:续期佣金;5:服务津贴;等等)
     */
    @Schema(description = "来佣名称(1:销售拥金;2:销售奖金;3:销售津贴;4:续期佣金;5:服务津贴;等等)", requiredMode = Schema.RequiredMode.REQUIRED)
    private String commissionName;

    /**
     * 来佣类型(1:销售拥金;2:销售奖金;3:销售津贴;4:续期佣金;5:服务津贴;等等)
     */
    @Schema(description = "来佣类型(1:销售拥金;2:销售奖金;3:销售津贴;4:续期佣金;5:服务津贴;等等)")
    private String commissionType;
    /**
     * 来佣金额
     */
    @Schema(description = "来佣金额", requiredMode = Schema.RequiredMode.REQUIRED)
    private BigDecimal amount;

    /**
     * 来佣币种
     */
    @Schema(description = "来佣币种", requiredMode = Schema.RequiredMode.REQUIRED)
    private String currency;

    /**
     * 来佣日期
     */
    @Schema(description = "来佣日期", requiredMode = Schema.RequiredMode.REQUIRED, format = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date commissionDate;

    private static final long serialVersionUID = 1L;
}
