package com.yd.csf.service.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 预计发佣统计VO 预计发佣金额 HKD、已出账金额 HKD、待出账金额 HKD、总保单数、总保费 HKD
 */
@Data
public class ExpectedFortuneStatisticsVO {

    /**
     * 预计发佣金额 HKD
     */
    @Schema(description = "预计发佣金额 HKD")
    private BigDecimal totalExpectedAmount;

    /**
     * 已出账金额 HKD
     */
    @Schema(description = "已出账金额 HKD")
    private BigDecimal totalPaidAmount;

    /**
     * 待出账金额 HKD
     */
    @Schema(description = "待出账金额 HKD")
    private BigDecimal totalUnpaidAmount;

    /**
     * 已出账比例（已出账金额/预计发佣金额）
     */
    @Schema(description = "已出账比例（已出账金额/预计发佣金额）")
    private String paidAmountRatio;

    /**
     * 总保单数
     */
    @Schema(description = "总保单数")
    private Integer totalPolicyCount;

    /**
     * 总保费 HKD
     */
    @Schema(description = "总保费 HKD")
    private BigDecimal totalPremiumAmount;

}
