package com.yd.csf.feign.dto.appointment;

import com.yd.csf.feign.dto.AddressDto;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 受益人信息
 */
@Data
public class ApiBeneficiaryInfoDto {

    /**
     * 受益人信息主键id（新增不需要传值，修改需要传值）
     */
    private Long id;

    /**
     * 预约信息主表唯一业务ID（新增不需要传值，修改需要传值）
     */
    private String appointmentBizId;

    /**
     * 受益人信息表唯一业务ID（新增不需要传值，修改需要传值）
     */
    private String beneficiaryBizId;

    /**
     * 客户类型（字典）(个人或者公司)
     */
//    @NotBlank(message = "客户类型不能为空")
    private String customerType;

    /**
     * 与受保人关系（字典）
     */
//    @NotBlank(message = "与受保人关系不能为空")
    private String insurantRel;

    /**
     * 受益比例
     */
    private BigDecimal benefitRatio;

    /**
     * 名字
     */
    private String name;

    /**
     * 名字-英文
     */
    private String nameEn;

    /**
     * 性别（字典）
     */
    private String gender;

    /**
     * 证件类型（字典）
     */
    private String documentType;

    /**
     * 证件号码
     */
    private String idNumber;

    /**
     * 护照号码
     */
    private String passportNumber;

    /**
     * 出生日期
     */
    private LocalDateTime birthTime;

    /**
     * 公司名称
     */
    private String companyName;

    /**
     * 公司名称（英文）
     */
    private String companyNameEn;

    /**
     * 公司商业登记号码
     */
    private String companyBusinessNo;

    /**
     * 公司注册日期
     */
    private LocalDateTime companyRegisterTime;

    /**
     * 公司注册地区（字典）
     */
    private String companyRegisterRegion;

    /**
     * 公司电话区号
     */
    private String companyMobileCode;

    /**
     * 公司电话
     */
    private String companyMobile;

    /**
     * 公司邮箱
     */
    private String companyEmail;

    /**
     * 公司登记地址
     */
    private String companyEnterAddress;

    /**
     * 通讯地址
     */
    private String mailingAddress;

    /**
     * 授权代表姓名中文-名字
     */
    private String authNameCn;

    /**
     * 授权代表姓名英文-名字
     */
    private String authNameEn;

    /**
     * 授权代表职称
     */
    private String authProfessional;

    /**
     * 授权代表电话区号
     */
    private String authMobileCode;

    /**
     * 授权代表电话
     */
    private String authMobile;

    /**
     * 地址列表
     */
    private List<AddressDto> addressList;
}
