package com.yd.csf.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 预计发佣表
 * </p>
 *
 * @author zxm
 * @since 2025-11-17
 */
@Getter
@Setter
@TableName("expected_fortune")
public class ExpectedFortune implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 预计发佣表唯一业务id
     */
    @TableField("expected_fortune_biz_id")
    private String expectedFortuneBizId;

    /**
     * 应付款类型 R-关联保单应付款 U-非关联保单应付款
     */
    @TableField("fortune_biz_type")
    private String fortuneBizType;

    /**
     * 应付款编号
     */
    @TableField("payable_no")
    private String payableNo;

    /**
     * 保单号
     */
    @TableField("policy_no")
    private String policyNo;

    /**
     * 期交保费
     */
    @TableField("premium")
    private BigDecimal premium;

    /**
     * 保险公司 ID
     */
    @TableField("insurance_company_biz_id")
    private String insuranceCompanyBizId;

    /**
     * 产品上架信息业务ID
     */
    @TableField("product_launch_biz_id")
    private String productLaunchBizId;

    /**
     * 发佣期数(1=第一年; 2=第二年; 3=第三年; 4=第四年; 5=第五年)
     */
    @TableField("fortune_period")
    private Integer fortunePeriod;

    /**
     * 发佣总期数
     */
    @TableField("fortune_total_period")
    private Integer fortuneTotalPeriod;

    /**
     * 转介人名称
     */
    @TableField("broker")
    private String broker;

    /**
     * 转介人业务ID
     */
    @TableField("broker_biz_id")
    private String brokerBizId;

    /**
     * 团队名称
     */
    @TableField("team")
    private String team;

    /**
     * 所属团队业务ID
     */
    @TableField("team_biz_id")
    private String teamBizId;

    /**
     * 发佣名称
     */
    @TableField("fortune_name")
    private String fortuneName;

    /**
     * 发佣类型
     */
    @TableField("fortune_type")
    private String fortuneType;

    /**
     * 转介人介绍费占比
     */
    @TableField("broker_ratio")
    private String brokerRatio;

    /**
     * 标准发佣金额
     */
    @TableField("standard_amount")
    private BigDecimal standardAmount;

    /**
     * 实际发佣金额（实际发佣金额 = 标准发佣金额 * 转介人介绍费占比）
     */
    @TableField("amount")
    private BigDecimal amount;

    /**
     * 发佣币种
     */
    @TableField("currency")
    private String currency;

    /**
     * 出账状态 0=待出账 1=可出帐 2=可出帐，待检核 3=部分出账 4=保留 5=已失效 6=可出账, 已检核 7=未找到当前预计发佣对应的来佣 字典值: csf_expected_fortune_status
     */
    @TableField("status")
    private String status;

    /**
     * 出账状态-修改理由
     */
    @TableField("status_desc")
    private String statusDesc;

    /**
     * 本次出账金额
     */
//    @TableField("current_payment_amount")
//    private BigDecimal currentPaymentAmount;

    /**
     * 预计出账日期
     */
    @TableField("payout_date")
    private LocalDate payoutDate;

    /**
     * 实际出账日期
     */
    @TableField("actual_payout_date")
    private LocalDate actualPayoutDate;

    /**
     * 默认结算汇率
     */
    @TableField("default_exchange_rate")
    private BigDecimal defaultExchangeRate;

    /**
     * 港币预计出账金额
     */
    @TableField("hkd_amount")
    private BigDecimal hkdAmount;

    /**
     * 已出账金额
     */
    @TableField("paid_amount")
    private BigDecimal paidAmount;

    /**
     * 待出账金额
     */
    @TableField("unpaid_amount")
    private BigDecimal unpaidAmount;

    /**
     * 已出账比例 已出账金额/应出账金额
     */
    @TableField("paid_ratio")
    private BigDecimal paidRatio;

    /**
     * 待出账比例
     */
    @TableField("unpaid_ratio")
    private BigDecimal unpaidRatio;

    /**
     * 是否含税 0=No, 1=Yes
     */
    @TableField("is_tax")
    private Integer isTax;

    /**
     * 应缴税额
     */
    @TableField("tax_amount")
    private BigDecimal taxAmount;

    /**
     * 税后发佣
     */
    @TableField("net_amount")
    private BigDecimal netAmount;

    /**
     * 基本法项目配置表唯一业务ID
     */
    @TableField("rule_item_biz_id")
    private String ruleItemBizId;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
