package com.yd.csf.feign.client.premiumreconciliation;

import com.yd.common.result.Result;
import com.yd.csf.feign.dto.premiumreconciliation.ApiPremiumReconciliationDto;
import com.yd.csf.feign.fallback.premiumreconciliation.ApiPremiumReconciliationFeignFallbackFactory;
import com.yd.csf.feign.request.premiumreconciliation.ApiPremiumReconciliationAddRequest;
import com.yd.csf.feign.request.premiumreconciliation.ApiPremiumReconciliationPageRequest;
import com.yd.csf.feign.request.premiumreconciliation.ApiPremiumReconciliationResultEditRequest;
import com.yd.csf.feign.request.premiumreconciliation.ApiCalculateRemainingUnpaidAmountRequest;
import com.yd.csf.feign.response.premiumreconciliation.ApiPremiumReconciliationDetailResponse;
import com.yd.csf.feign.response.premiumreconciliation.ApiCalculateRemainingUnpaidAmountResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import javax.validation.constraints.NotBlank;

/**
 * 香港保险服务-保费对账记录信息Feign客户端
 */
@FeignClient(name = "yd-csf-api", fallbackFactory = ApiPremiumReconciliationFeignFallbackFactory.class)
public interface ApiPremiumReconciliationFeignClient {

    /**
     * 分页列表查询-保费对账记录信息
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@RequestBody ApiPremiumReconciliationPageRequest request);

    /**
     * 添加-保费对账记录信息（聚合信息添加）
     * @param request
     * @return
     */
    @PostMapping("/add")
    Result add(@Validated @RequestBody ApiPremiumReconciliationAddRequest request);

    /**
     * 编辑-单个保费对账记录信息
     * @param request
     * @return
     */
    @PutMapping("/edit")
    Result edit(@Validated @RequestBody ApiPremiumReconciliationDto request);

    /**
     * 详情-保费对账记录信息
     * @param premiumReconciliationBizId 保费对账记录表唯一业务ID
     * @return
     */
    @GetMapping("/detail")
    Result<ApiPremiumReconciliationDetailResponse> detail(@NotBlank(message = "保费对账记录表唯一业务ID能为空") @RequestParam(value = "premiumReconciliationBizId") String premiumReconciliationBizId);

    /**
     * 计算待付金额-保费对账记录信息
     * @param request
     * @return
     */
    @PostMapping("/calculate/remainingUnpaidAmount")
    Result<ApiCalculateRemainingUnpaidAmountResponse> calculateRemainingUnpaidAmount(@Validated @RequestBody ApiCalculateRemainingUnpaidAmountRequest request);

    /**
     * 设置认定结果-保费对账记录信息
     * @param request
     * @return
     */
    @PutMapping("/edit/result")
    Result editResult(@Validated @RequestBody ApiPremiumReconciliationResultEditRequest request);

    /**
     * 校验-保单所有期数的保费对账是否对账完成（全部对账完成就不能新增录入对账信息了）
     * @param policyNo
     * @return
     */
    @GetMapping("/check/reconciliation/complete")
    Result<Boolean> checkReconciliationComplete(@NotBlank(message = "保单号能为空") @RequestParam(value = "policyNo") String policyNo);
}
