package com.yd.csf.api;

import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;

@SpringBootApplication(scanBasePackages = "com.yd")
@MapperScan("com.yd.**.dao")
@EnableFeignClients(basePackages = "com.yd")
@ComponentScan(basePackages = {
        "com.yd.auth.core"  // 包含认证模块的包路径
})
public class CsfApiApplication {

    public static void main(String[] args) {
        new SpringApplicationBuilder(CsfApiApplication.class)
                .properties("spring.application.name=" + "yd-csf-api")
                .build().run(args);
        System.out.println("(♥◠‿◠)ﾉﾞ  yd-csf-api启动成功   ლ(´ڡ`ლ)ﾞ ");
    }
}
