package com.yd.csf.service.enums;

/**
 * fna状态枚举
 * 'FILING'-建档中, 'FNA_FILLING'-FNA填写中, 'APPOINTMENT_FILLING'-预约资料填写,
 * 'PENDING_SIGNATURE'-待签单, 'SIGNED_COMPLETED'-签单完成, 'CANCELLED'-已作废
 */
public enum FnaStatusEnum {
    FILING("建档中", "FILING"),
    FNA_FILLING("FNA填写中", "FNA_FILLING"),
    APPOINTMENT_FILLING("预约资料填写", "APPOINTMENT_FILLING"),
    PENDING_SIGNATURE("待签单", "PENDING_SIGNATURE"),
    SIGNED_COMPLETED("签单完成", "SIGNED_COMPLETED"),
    CANCELLED("已作废", "CANCELLED"),
    ;
    //字典项标签（名称）
    private String itemLabel;
    //字典项值
    private String itemValue;

    //构造函数
    FnaStatusEnum(String itemLabel, String itemValue) {
        this.itemLabel = itemLabel;
        this.itemValue = itemValue;
    }

    public String getItemLabel() {
        return itemLabel;
    }

    public String getItemValue() {
        return itemValue;
    }
}
