package com.yd.csf.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 保单回执表
 * </p>
 *
 * @author zxm
 * @since 2025-12-25
 */
@Getter
@Setter
@TableName("policy_receipt")
public class PolicyReceipt implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 保单回执表唯一业务ID
     */
    @TableField("policy_receipt_biz_id")
    private String policyReceiptBizId;

    /**
     * 保单号
     */
    @TableField("policy_no")
    private String policyNo;

    /**
     * 回执状态（CONFIRMED-已确认 UNCONFIRMED-未确认）
     */
    @TableField("receipt_status")
    private String receiptStatus;

    /**
     * 回执日期
     */
    @TableField("receipt_date")
    private LocalDateTime receiptDate;

    /**
     * 保单持有人签名（图片URL）
     */
    @TableField("policy_holder_signature")
    private String policyHolderSignature;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
