package com.yd.csf.service.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yd.csf.service.model.PolicyFollowRecord;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.springframework.beans.BeanUtils;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Data
public class PolicyFollowRecordVO implements Serializable {
    @Schema(description = "id")
    private Long id;

    /**
     * 新单跟进唯一业务ID
     */
    @Schema(description = "新单跟进唯一业务ID")
    private String policyBizId;

    /**
     * 跟进状态
     */
    @Schema(description = "跟进状态")
    private String title;

    /**
     * 跟进信息
     */
    @Schema(description = "跟进信息")
    private String message;

    /**
     * 创建人ID
     */
    @Schema(description = "创建人ID")
    private String creatorId;

    /**
     * 创建人姓名
     */
    @Schema(description = "创建人姓名")
    private String creatorName;

     /**
     * 创建时间
     */
    @Schema(description = "创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    private static final long serialVersionUID = 1L;

    public static PolicyFollowRecordVO objToVO(PolicyFollowRecord policyFollowRecord) {
        if (policyFollowRecord == null) {
            return null;
        }
        PolicyFollowRecordVO policyFollowRecordVO = new PolicyFollowRecordVO();
        BeanUtils.copyProperties(policyFollowRecord, policyFollowRecordVO);
        return policyFollowRecordVO;
    }
}
