package com.yd.csf.feign.request.appointment;

import com.yd.common.dto.PageDto;
import lombok.Data;
import java.time.LocalDateTime;

/**
 * 预约分页查询入参
 */
@Data
public class ApiAppointmentPageRequest extends PageDto {

    /**
     * 预约状态: 0-暂存 1-待预约, 2-待签署 3-已签署 4-已取消（字典）
     */
    private Integer status;

    /**
     * 预约编号
     */
    private String appointmentNo;

    /**
     * 客户姓名（客户表的姓名） TODO
     */
    private String customerName;

    /**
     * 客户编号（客户表的客户编号）
     */
    private String customerNo;

    /**
     * 保险产品唯一业务ID
     */
    private String productBizId;

    /**
     * 确定预约开始时间
     */
    private LocalDateTime startTime;

    /**
     * 确定预约结束时间
     */
    private LocalDateTime endTime;
}
