package com.yd.csf.feign.dto.appointment;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.time.LocalDateTime;

@Data
public class ApiAppointmentReferrerLogDto {

    /**
     * 预约-转介人信息日志表主键ID
     */
    private Long id;

    /**
     * 预约-转介人信息日志表唯一业务ID
     */
    private String appointmentReferrerLogBizId;

    /**
     * 预约信息日志表唯一业务ID
     */
    private String appointmentLogBizId;

    /**
     * 系统用户-销售用户扩展表唯一业务ID（转介人，冗余）
     */
    private String userSaleBizId;

    /**
     * 系统用户唯一业务ID（冗余）
     */
    private String userBizId;

    /**
     * 姓名
     */
    private String realName;

    /**
     * 手机号
     */
    private String phone;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 通用备注
     */
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    private String creatorId;

    /**
     * 更新人ID
     */
    private String updaterId;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime updateTime;
}
