package com.yd.csf.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.csf.feign.request.conditiontype.ApiConditionTypePageRequest;
import com.yd.csf.feign.response.conditiontype.ApiConditionTypePageResponse;
import com.yd.csf.service.dto.ConditionTypeDto;
import com.yd.csf.service.model.ConditionConfig;
import com.yd.csf.service.model.ConditionType;
import com.yd.csf.service.dao.ConditionTypeMapper;
import com.yd.csf.service.model.FormulaConfig;
import com.yd.csf.service.service.IConditionTypeService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * <p>
 * 条件类型表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-10-17
 */
@Service
public class ConditionTypeServiceImpl extends ServiceImpl<ConditionTypeMapper, ConditionType> implements IConditionTypeService {

    /**
     * 查询列表
     * @param dto
     * @return
     */
    @Override
    public List<ConditionType> queryList(ConditionTypeDto dto) {
        List<ConditionType> list = baseMapper.selectList(new LambdaQueryWrapper<ConditionType>()
                .eq(StringUtils.isNotBlank(dto.getConditionTypeBizId()) && !dto.getIsExcludeMy(), ConditionType::getConditionTypeBizId,dto.getConditionTypeBizId())
                .eq(StringUtils.isNotBlank(dto.getName()),ConditionType::getName,dto.getName())
                .ne(dto.getIsExcludeMy(),ConditionType::getConditionTypeBizId,dto.getConditionTypeBizId())
                .in(!CollectionUtils.isEmpty(dto.getConditionTypeBizIdList()),ConditionType::getConditionTypeBizId,dto.getConditionTypeBizIdList())
        );
        return list;
    }

    /**
     * 查询单个对象
     * @param conditionTypeBizId
     * @return
     */
    @Override
    public ConditionType queryOne(String conditionTypeBizId) {
        return this.getOne(new LambdaQueryWrapper<ConditionType>().eq(ConditionType::getConditionTypeBizId,conditionTypeBizId));
    }

    @Override
    public IPage<ApiConditionTypePageResponse> page(Page<ApiConditionTypePageResponse> page,
                                                    ApiConditionTypePageRequest request) {
        return baseMapper.page(page,request);
    }
}
