package com.yd.csf.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.csf.api.service.ApiAppointmentService;
import com.yd.csf.feign.client.appointment.ApiAppointmentFeignClient;
import com.yd.csf.feign.dto.appointment.ApiAppointmentInfoDto;
import com.yd.csf.feign.request.appointment.*;
import com.yd.csf.feign.response.appointment.ApiAppointmentDetailResponse;
import com.yd.csf.feign.response.appointment.ApiAppointmentPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 预约信息
 *
 * @author zxm
 * @since 2025-09-01
 */
@RestController
@RequestMapping("/appointment")
@Validated
public class ApiAppointmentController implements ApiAppointmentFeignClient {

    @Autowired
    private ApiAppointmentService apiAppointmentService;

    /**
     * 预约分页查询
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiAppointmentPageResponse>> page(ApiAppointmentPageRequest request) {
        return apiAppointmentService.page(request);
    }

    /**
     * 预约详情（聚合信息详情）
     * @param appointmentBizId
     * @return
     */
    @Override
    public Result<ApiAppointmentDetailResponse> detail(String appointmentBizId) {
        return apiAppointmentService.detail(appointmentBizId);
    }

    /**
     * 预约主体信息详情（单个对象详情）
     * @param appointmentBizId
     * @return
     */
    @Override
    public Result<ApiAppointmentInfoDto> mainDetail(String appointmentBizId) {
        return apiAppointmentService.mainDetail(appointmentBizId);
    }

    /**
     * 新增预约提交 (聚合信息新增预约提交)
     * @param request
     * @return
     */
    @Override
    public Result add(ApiAppointmentAddRequest request) {
        return apiAppointmentService.add(request);
    }

    /**
     * 新增预约暂存
     * @param request
     * @return
     */
    @Override
    public Result addStorage(ApiAppointmentAddStorageRequest request) {
        return apiAppointmentService.addStorage(request);
    }

    /**
     * 编辑预约提交 (聚合信息编辑预约提交)
     * @param request
     * @return
     */
    @Override
    public Result edit(ApiAppointmentEditRequest request) {
        return apiAppointmentService.edit(request);
    }

    /**
     * 确定预约时间提交 (流程流转到新单跟进)
     * @param request
     * @return
     */
    @Override
    public Result editConfirmTime(ApiAppointmentEditConfirmTimeRequest request) {
        return apiAppointmentService.editConfirmTime(request);
    }

    /**
     * 单个对象编辑-编辑预约主体信息
     * @param apiAppointmentInfoDto
     * @return
     */
    @Override
    public Result singleEdit(ApiAppointmentInfoDto apiAppointmentInfoDto) {
        return apiAppointmentService.singleEdit(apiAppointmentInfoDto);
    }

    /**
     * 预约编辑关联FNA
     * @param request
     * @return
     */
    @Override
    public Result editFna(ApiAppointmentEditFnaRequest request) {
        return apiAppointmentService.editFna(request);
    }

    /**
     * 预约解除关联FNA
     * @param request
     * @return
     */
    @Override
    public Result removeFna(ApiAppointmentRemoveFnaRequest request) {
        return apiAppointmentService.removeFna(request);
    }

    /**
     * 预约编辑关联计划书
     * @param request
     * @return
     */
    @Override
    public Result editProposal(ApiAppointmentEditProposalRequest request) {
        return apiAppointmentService.editProposal(request);
    }

    /**
     * 预约解除关联计划书
     * @param request
     * @return
     */
    @Override
    public Result removeProposal(ApiAppointmentRemoveProposalRequest request) {
        return apiAppointmentService.removeProposal(request);
    }


}
