package com.yd.csf.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 产品计划-附加险信息表
 * </p>
 *
 * @author zxm
 * @since 2025-09-01
 */
@Getter
@Setter
@TableName("additional")
public class Additional implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 附加险信息表唯一业务ID
     */
    @TableField("additional_biz_id")
    private String additionalBizId;

    /**
     * 产品计划信息表唯一业务ID
     */
    @TableField("plan_biz_id")
    private String planBizId;

    /**
     * 保险附加产品唯一业务ID（中台保险附加产品业务id，冗余）
     */
    @TableField("additional_product_biz_id")
    private String additionalProductBizId;

    /**
     * 保险附加产品名称（中台保险附加产品名称，冗余）
     */
    @TableField("product_name")
    private String productName;

    /**
     * 货币（字典）
     */
    @TableField("currency")
    private String currency;

    /**
     * 保费
     */
    @TableField("premium")
    private BigDecimal premium;

    /**
     * 保额
     */
    @TableField("sum_insured")
    private BigDecimal sumInsured;

    /**
     * 保障地区（字典）
     */
    @TableField("guarantee_region")
    private String guaranteeRegion;

    /**
     * 等级（字典）
     */
    @TableField("level")
    private String level;

    /**
     * 自付额（字典）
     */
    @TableField("deductibles")
    private String deductibles;

    /**
     * 附加保障（json串）
     */
    @TableField("additional_safeguards")
    private String additionalSafeguards;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
