package com.yd.csf.service.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yd.csf.service.dto.*;
import com.yd.csf.service.enums.PolicyFollowStatusEnum;
import com.yd.csf.service.model.PolicyFollow;
import com.yd.csf.service.vo.PolicyFollowDetailVO;
import com.yd.csf.service.vo.PolicyFollowVO;

import java.util.Map;

/**
* @author Zhang Jianan
* @description 针对表【policy_follow(新单跟进表)】的数据库操作Service
* @createDate 2025-09-16 18:18:06
*/
public interface PolicyFollowService extends IService<PolicyFollow> {

    PolicyFollow getByPolicyBizId(String policyBizId);

    QueryWrapper<PolicyFollow> getQueryWrapper(PolicyFollowQueryRequest policyFollowQueryRequest);

    Page<PolicyFollowVO> getPolicyFollowVOPage(Page<PolicyFollow> policyFollowPage);

    Boolean updatePolicyFollow(PolicyFollowUpdateRequest policyFollowUpdateRequest);

    PolicyFollowVO getPolicyFollowVO(PolicyFollow policyFollow);

    Map<String, Object> addPolicyFollow(PolicyFollowAddRequest policyFollowAddRequest);

    Boolean addToPolicy(AddToPolicyRequest addToPolicyRequest);

    Boolean changePolicyFollowStatus(ChangePolicyFollowStatusRequest changePolicyFollowStatusRequest);

    Boolean uploadAttachment(AttachmentUploadRequest attachmentUploadRequest);

    String getNextStatus(PolicyFollowStatusEnum policyFollowStatusEnum);

    PolicyFollowAggregateDto getPolicyFollowAggregate(String policyBizId);

    Page<PolicyFollowDetailVO> getPolicyFollowDetailVOList(Page<PolicyFollow> policyFollowPage);
}
