package com.yd.csf.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yd.csf.service.dto.RelObjectSqlDto;
import com.yd.csf.service.model.RelObjectFormula;
import com.yd.csf.service.model.RelObjectSql;
import com.yd.csf.service.dao.RelObjectSqlMapper;
import com.yd.csf.service.service.IRelObjectSqlService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 对象和SQL模板配置关系表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-10-17
 */
@Service
public class RelObjectSqlServiceImpl extends ServiceImpl<RelObjectSqlMapper, RelObjectSql> implements IRelObjectSqlService {

    /**
     * 查询列表
     * @param dto
     * @return
     */
    @Override
    public List<RelObjectSql> queryList(RelObjectSqlDto dto) {
        List<RelObjectSql> list = baseMapper.selectList(new LambdaQueryWrapper<RelObjectSql>()
                .eq(StringUtils.isNotBlank(dto.getObjectBizId()),RelObjectSql::getObjectBizId,dto.getObjectBizId())
        );
        return list;
    }

    /**
     * 删除关系
     * @param dto
     * @return
     */
    @Override
    public Boolean del(RelObjectSqlDto dto) {
        return this.remove(new LambdaQueryWrapper<RelObjectSql>().eq(RelObjectSql::getObjectBizId,dto.getObjectBizId()));
    }

}
